/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.scripting.model;

import com.aptana.scope.ScopeSelector;
import com.aptana.scripting.model.AbstractBundleElement;
import com.aptana.scripting.model.AbstractElement;
import com.aptana.scripting.model.BuildPathElement;
import com.aptana.scripting.model.BundleElement;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.BundleProcessor;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.ContentAssistElement;
import com.aptana.scripting.model.EnvironmentElement;
import com.aptana.scripting.model.MenuElement;
import com.aptana.scripting.model.Messages;
import com.aptana.scripting.model.ProjectSampleElement;
import com.aptana.scripting.model.ProjectTemplateElement;
import com.aptana.scripting.model.SmartTypingPairsElement;
import com.aptana.scripting.model.SnippetCategoryElement;
import com.aptana.scripting.model.SnippetElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jruby.RubyRegexp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleEntry {
    private String _name;
    private List<BundleElement> _bundles;
    private Comparator<BundleElement> _comparator = new Comparator<BundleElement>(){

        @Override
        public int compare(BundleElement o1, BundleElement o2) {
            int result = o1.getBundlePrecedence().compareTo(o2.getBundlePrecedence());
            if (result == 0) {
                result = o1.isReference() == o2.isReference() ? o1.getPath().compareTo(o2.getPath()) : (o1.isReference() ? 1 : -1);
            }
            return result;
        }
    };

    public BundleEntry(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException(Messages.BundleEntry_Name_Not_Defined);
        }
        this._name = name;
        this._bundles = Collections.synchronizedList(new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BundleEntry(String name, List<BundleElement> bundles) {
        this._name = name;
        List<BundleElement> list = this._bundles = Collections.synchronizedList(bundles);
        synchronized (list) {
            Collections.sort(this._bundles, this._comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBundle(BundleElement bundle) {
        if (bundle != null && !this._bundles.contains(bundle)) {
            VisibilityContext context = this.getVisibilityContext();
            this._bundles.add(bundle);
            List<BundleElement> list = this._bundles;
            synchronized (list) {
                Collections.sort(this._bundles, this._comparator);
            }
            context.updateElementContext();
            context.fireElementVisibilityEvents();
        }
    }

    public List<BuildPathElement> getBuildPaths() {
        NameBasedProcessor<BuildPathElement> processor = new NameBasedProcessor<BuildPathElement>(this){

            @Override
            protected List<BuildPathElement> getElements(BundleElement bundle) {
                return bundle.getBuildPaths();
            }
        };
        this.processBundles(processor);
        return processor.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BundleElement> getBundles() {
        List<BundleElement> list = this._bundles;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<BundleElement>(this._bundles));
        }
    }

    public List<CommandElement> getCommands() {
        NameBasedProcessor<CommandElement> processor = new NameBasedProcessor<CommandElement>(this){

            @Override
            protected List<CommandElement> getElements(BundleElement bundle) {
                return bundle.getCommands();
            }
        };
        this.processBundles(processor);
        return processor.getResult();
    }

    public List<ContentAssistElement> getContentAssists() {
        NameBasedProcessor<ContentAssistElement> processor = new NameBasedProcessor<ContentAssistElement>(this){

            @Override
            protected List<ContentAssistElement> getElements(BundleElement bundle) {
                return bundle.getContentAssists();
            }
        };
        this.processBundles(processor);
        return processor.getResult();
    }

    public List<BundleElement> getContributingBundles() {
        final ArrayList<BundleElement> result = new ArrayList<BundleElement>();
        this.processBundles(new BundleProcessor(){

            public boolean processBundle(BundleEntry entry, BundleElement bundle) {
                result.add(bundle);
                return true;
            }
        });
        return result;
    }

    public Map<ScopeSelector, RubyRegexp> getDecreaseIndentMarkers() {
        final HashMap<ScopeSelector, RubyRegexp> result = new HashMap<ScopeSelector, RubyRegexp>();
        this.processBundles(new BundleProcessor(){

            public boolean processBundle(BundleEntry entry, BundleElement bundle) {
                Map<ScopeSelector, RubyRegexp> registry = bundle.getDecreaseIndentMarkers();
                if (registry != null) {
                    result.putAll(registry);
                }
                return true;
            }
        });
        return result;
    }

    public List<EnvironmentElement> getEnvs() {
        NameBasedProcessor<EnvironmentElement> processor = new NameBasedProcessor<EnvironmentElement>(this){

            @Override
            protected List<EnvironmentElement> getElements(BundleElement bundle) {
                return bundle.getEnvs();
            }
        };
        this.processBundles(processor);
        return processor.getResult();
    }

    public Map<String, String> getFileTypeRegistry() {
        final HashMap<String, String> result = new HashMap<String, String>();
        this.processBundles(new BundleProcessor(){

            public boolean processBundle(BundleEntry entry, BundleElement bundle) {
                Map<String, String> registry = bundle.getFileTypeRegistry();
                if (registry != null) {
                    result.putAll(registry);
                    return false;
                }
                return true;
            }
        });
        return result;
    }

    public List<String> getFileTypes() {
        final ArrayList<String> result = new ArrayList<String>();
        this.processBundles(new BundleProcessor(){

            public boolean processBundle(BundleEntry entry, BundleElement bundle) {
                List<String> registry = bundle.getFileTypes();
                if (registry != null) {
                    result.addAll(registry);
                }
                return true;
            }
        });
        return result;
    }

    public Map<ScopeSelector, RubyRegexp> getFoldingStartMarkers() {
        final HashMap<ScopeSelector, RubyRegexp> result = new HashMap<ScopeSelector, RubyRegexp>();
        this.processBundles(new BundleProcessor(){

            public boolean processBundle(BundleEntry entry, BundleElement bundle) {
                Map<ScopeSelector, RubyRegexp> registry = bundle.getFoldingStartMarkers();
                if (registry != null) {
                    result.putAll(registry);
                }
                return true;
            }
        });
        return result;
    }

    public Map<ScopeSelector, RubyRegexp> getFoldingStopMarkers() {
        final HashMap<ScopeSelector, RubyRegexp> result = new HashMap<ScopeSelector, RubyRegexp>();
        this.processBundles(new BundleProcessor(){

            public boolean processBundle(BundleEntry entry, BundleElement bundle) {
                Map<ScopeSelector, RubyRegexp> registry = bundle.getFoldingStopMarkers();
                if (registry != null) {
                    result.putAll(registry);
                }
                return true;
            }
        });
        return result;
    }

    public Map<ScopeSelector, RubyRegexp> getIncreaseIndentMarkers() {
        final HashMap<ScopeSelector, RubyRegexp> result = new HashMap<ScopeSelector, RubyRegexp>();
        this.processBundles(new BundleProcessor(){

            public boolean processBundle(BundleEntry entry, BundleElement bundle) {
                Map<ScopeSelector, RubyRegexp> registry = bundle.getIncreaseIndentMarkers();
                if (registry != null) {
                    result.putAll(registry);
                }
                return true;
            }
        });
        return result;
    }

    public List<String> getLoadPaths() {
        final LinkedList<String> result = new LinkedList<String>();
        this.processBundles(new BundleProcessor(){

            public boolean processBundle(BundleEntry entry, BundleElement bundle) {
                result.addAll(bundle.getLoadPaths());
                return true;
            }
        });
        return result;
    }

    public List<MenuElement> getMenus() {
        NameBasedProcessor<MenuElement> processor = new NameBasedProcessor<MenuElement>(this){

            @Override
            protected List<MenuElement> getElements(BundleElement bundle) {
                return bundle.getMenus();
            }
        };
        this.processBundles(processor);
        return processor.getResult();
    }

    public String getName() {
        return this._name;
    }

    public List<SmartTypingPairsElement> getPairs() {
        NameBasedProcessor<SmartTypingPairsElement> processor = new NameBasedProcessor<SmartTypingPairsElement>(this){

            @Override
            protected List<SmartTypingPairsElement> getElements(BundleElement bundle) {
                return bundle.getPairs();
            }
        };
        this.processBundles(processor);
        return processor.getResult();
    }

    public List<ProjectTemplateElement> getProjectTemplates() {
        NameBasedProcessor<ProjectTemplateElement> processor = new NameBasedProcessor<ProjectTemplateElement>(this){

            @Override
            protected List<ProjectTemplateElement> getElements(BundleElement bundle) {
                return bundle.getProjectTemplates();
            }
        };
        this.processBundles(processor);
        return processor.getResult();
    }

    public List<ProjectSampleElement> getProjectSamples() {
        NameBasedProcessor<ProjectSampleElement> processor = new NameBasedProcessor<ProjectSampleElement>(this){

            @Override
            protected List<ProjectSampleElement> getElements(BundleElement bundle) {
                return bundle.getProjectSamples();
            }
        };
        this.processBundles(processor);
        return processor.getResult();
    }

    public List<SnippetElement> getSnippets() {
        NameBasedProcessor<SnippetElement> processor = new NameBasedProcessor<SnippetElement>(this){

            @Override
            protected List<SnippetElement> getElements(BundleElement bundle) {
                return bundle.getSnippets();
            }
        };
        this.processBundles(processor);
        return processor.getResult();
    }

    public List<SnippetCategoryElement> getSnippetCategories() {
        NameBasedProcessor<SnippetCategoryElement> processor = new NameBasedProcessor<SnippetCategoryElement>(this){

            @Override
            protected List<SnippetCategoryElement> getElements(BundleElement bundle) {
                return bundle.getSnippetCategories();
            }
        };
        this.processBundles(processor);
        return processor.getResult();
    }

    public VisibilityContext getVisibilityContext() {
        return new VisibilityContext();
    }

    public VisibilityContext getVisibilityContext(Class<? extends AbstractBundleElement> elementClass) {
        return new VisibilityContext(elementClass);
    }

    protected void processBundles(BundleProcessor processor) {
        List<BundleElement> bundles = this.getBundles();
        int i = bundles.size() - 1;
        while (i >= 0) {
            BundleElement bundle = bundles.get(i);
            if (!processor.processBundle(this, bundle) || !bundle.isReference()) break;
            --i;
        }
    }

    public void reload() {
        BundleManager manager = BundleManager.getInstance();
        for (BundleElement bundle : this.getBundles()) {
            manager.reloadBundle(bundle);
        }
    }

    public boolean removeBundle(BundleElement bundle) {
        VisibilityContext context = this.getVisibilityContext();
        boolean removed = this._bundles.remove(bundle);
        if (removed) {
            context.updateElementContext();
            context.fireElementVisibilityEvents();
        }
        return removed;
    }

    public int size() {
        return this._bundles.size();
    }

    /* synthetic */ BundleEntry(String string, List list, BundleEntry bundleEntry) {
        this(string, list);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ChildVisibilityContext<T extends AbstractBundleElement> {
        private List<T> preVisibleItems = this.getElements();
        private Set<T> becameHidden;
        private Set<T> becameVisible;

        public void fireVisibilityEvents() {
            BundleManager manager = BundleManager.getInstance();
            if (this.becameHidden != null && this.becameHidden.size() > 0) {
                for (AbstractBundleElement element : this.becameHidden) {
                    manager.fireElementBecameHiddenEvent(element);
                }
            }
            if (this.becameVisible != null && this.becameVisible.size() > 0) {
                for (AbstractBundleElement element : this.becameVisible) {
                    manager.fireElementBecameVisibleEvent(element);
                }
            }
        }

        public abstract List<T> getElements();

        public void updateContext() {
            this.becameVisible = new HashSet<T>(this.getElements());
            this.becameHidden = new HashSet<T>(this.preVisibleItems);
            this.becameHidden.removeAll(this.becameVisible);
            this.becameVisible.removeAll(this.preVisibleItems);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class NameBasedProcessor<T extends AbstractElement>
    implements BundleProcessor {
        private Set<String> names = new HashSet<String>();
        private List<T> result = new ArrayList<T>();

        private NameBasedProcessor() {
        }

        protected abstract List<T> getElements(BundleElement var1);

        public List<T> getResult() {
            return this.result;
        }

        @Override
        public boolean processBundle(BundleEntry entry, BundleElement bundle) {
            for (AbstractElement command : this.getElements(bundle)) {
                String name = command.getDisplayName();
                if (this.names.contains(name)) continue;
                this.names.add(name);
                this.result.add(command);
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class VisibilityContext {
        private List<BundleElement> preVisibleBundles;
        private Set<BundleElement> becameVisible;
        private Set<BundleElement> becameHidden;
        private ChildVisibilityContext<CommandElement> commands;
        private ChildVisibilityContext<EnvironmentElement> envs;
        private ChildVisibilityContext<MenuElement> menus;
        private ChildVisibilityContext<SmartTypingPairsElement> pairs;
        private ChildVisibilityContext<ProjectTemplateElement> projectTemplates;
        private ChildVisibilityContext<ProjectSampleElement> projectSamples;
        private ChildVisibilityContext<SnippetElement> snippets;
        private ChildVisibilityContext<SnippetCategoryElement> snippetCategories;
        private ChildVisibilityContext<BuildPathElement> buildPaths;

        public VisibilityContext() {
            this(null);
        }

        public VisibilityContext(Class<? extends AbstractBundleElement> elementClass) {
            if (elementClass == null) {
                this.preVisibleBundles = BundleEntry.this.getContributingBundles();
            }
            if (elementClass == null || elementClass == CommandElement.class) {
                this.commands = new ChildVisibilityContext<CommandElement>(BundleEntry.this){

                    @Override
                    public List<CommandElement> getElements() {
                        return BundleEntry.this.getCommands();
                    }
                };
            }
            if (elementClass == null || elementClass == EnvironmentElement.class) {
                this.envs = new ChildVisibilityContext<EnvironmentElement>(BundleEntry.this){

                    @Override
                    public List<EnvironmentElement> getElements() {
                        return BundleEntry.this.getEnvs();
                    }
                };
            }
            if (elementClass == null || elementClass == MenuElement.class) {
                this.menus = new ChildVisibilityContext<MenuElement>(BundleEntry.this){

                    @Override
                    public List<MenuElement> getElements() {
                        return BundleEntry.this.getMenus();
                    }
                };
            }
            if (elementClass == null || elementClass == SmartTypingPairsElement.class) {
                this.pairs = new ChildVisibilityContext<SmartTypingPairsElement>(BundleEntry.this){

                    @Override
                    public List<SmartTypingPairsElement> getElements() {
                        return BundleEntry.this.getPairs();
                    }
                };
            }
            if (elementClass == null || elementClass == ProjectTemplateElement.class) {
                this.projectTemplates = new ChildVisibilityContext<ProjectTemplateElement>(BundleEntry.this){

                    @Override
                    public List<ProjectTemplateElement> getElements() {
                        return BundleEntry.this.getProjectTemplates();
                    }
                };
            }
            if (elementClass == null || elementClass == ProjectSampleElement.class) {
                this.projectSamples = new ChildVisibilityContext<ProjectSampleElement>(BundleEntry.this){

                    @Override
                    public List<ProjectSampleElement> getElements() {
                        return BundleEntry.this.getProjectSamples();
                    }
                };
            }
            if (elementClass == null || elementClass == SnippetElement.class) {
                this.snippets = new ChildVisibilityContext<SnippetElement>(BundleEntry.this){

                    @Override
                    public List<SnippetElement> getElements() {
                        return BundleEntry.this.getSnippets();
                    }
                };
            }
            if (elementClass == null || elementClass == SnippetCategoryElement.class) {
                this.snippetCategories = new ChildVisibilityContext<SnippetCategoryElement>(BundleEntry.this){

                    @Override
                    public List<SnippetCategoryElement> getElements() {
                        return BundleEntry.this.getSnippetCategories();
                    }
                };
            }
            if (elementClass == null || elementClass == BuildPathElement.class) {
                this.buildPaths = new ChildVisibilityContext<BuildPathElement>(BundleEntry.this){

                    @Override
                    public List<BuildPathElement> getElements() {
                        return BundleEntry.this.getBuildPaths();
                    }
                };
            }
        }

        private void fireBundleVisibilityEvents() {
            BundleManager manager = BundleManager.getInstance();
            if (this.becameHidden != null && this.becameHidden.size() > 0) {
                ArrayList<BundleElement> hiddenList = new ArrayList<BundleElement>(this.becameHidden);
                for (BundleElement bundle : hiddenList) {
                    bundle.setVisible(false);
                }
                BundleEntry hiddenEntry = new BundleEntry(BundleEntry.this.getName(), hiddenList, null);
                manager.fireBundleBecameHiddenEvent(hiddenEntry);
            }
            if (this.becameVisible != null && this.becameVisible.size() > 0) {
                ArrayList<BundleElement> visibleList = new ArrayList<BundleElement>(this.becameVisible);
                for (BundleElement bundle : visibleList) {
                    bundle.setVisible(true);
                }
                BundleEntry visibleEntry = new BundleEntry(BundleEntry.this.getName(), visibleList, null);
                manager.fireBundleBecameVisibleEvent(visibleEntry);
            }
        }

        public void fireElementVisibilityEvents() {
            if (this.preVisibleBundles != null) {
                this.fireBundleVisibilityEvents();
            }
            this.fireElementVisibilityEvents(this.commands);
            this.fireElementVisibilityEvents(this.envs);
            this.fireElementVisibilityEvents(this.menus);
            this.fireElementVisibilityEvents(this.pairs);
            this.fireElementVisibilityEvents(this.projectTemplates);
            this.fireElementVisibilityEvents(this.projectSamples);
            this.fireElementVisibilityEvents(this.snippets);
            this.fireElementVisibilityEvents(this.snippetCategories);
            this.fireElementVisibilityEvents(this.buildPaths);
        }

        private void fireElementVisibilityEvents(ChildVisibilityContext<? extends AbstractBundleElement> context) {
            if (context != null) {
                context.fireVisibilityEvents();
            }
        }

        private void updateBundleContext() {
            this.becameVisible = new HashSet<BundleElement>(BundleEntry.this.getContributingBundles());
            this.becameHidden = new HashSet<BundleElement>(this.preVisibleBundles);
            this.becameHidden.removeAll(this.becameVisible);
            this.becameVisible.removeAll(this.preVisibleBundles);
        }

        public void updateElementContext() {
            if (this.preVisibleBundles != null) {
                this.updateBundleContext();
            }
            this.updateElementContext(this.commands);
            this.updateElementContext(this.envs);
            this.updateElementContext(this.menus);
            this.updateElementContext(this.pairs);
            this.updateElementContext(this.projectTemplates);
            this.updateElementContext(this.projectSamples);
            this.updateElementContext(this.snippets);
            this.updateElementContext(this.snippetCategories);
            this.updateElementContext(this.buildPaths);
        }

        private void updateElementContext(ChildVisibilityContext<? extends AbstractBundleElement> context) {
            if (context != null) {
                context.updateContext();
            }
        }
    }
}

